local assets=
{
	Asset("ANIM", "anim/ancient_altar_mover.zip"),
	Asset("ANIM", "anim/swap_ancient_altar_mover.zip"),
	Asset("IMAGE", "images/ancient_altar_mover.tex"),
	Asset("ATLAS", "images/ancient_altar_mover.xml"),
}

local function OnSave(inst, data)
    if inst.stored and inst.stored == true then
        data["Papapa"] = "Guru"
    end
end

local function OnLoad(inst, data)
    if data and data["Papapa"] then
		inst.stored = true
	end
end

local function onequip(inst, owner)
	owner.AnimState:OverrideSymbol("swap_object", "swap_ancient_altar_mover", "swap_ancient_altar_mover")
	owner.AnimState:Show("ARM_carry")
	owner.AnimState:Hide("ARM_normal")
end

local function onunequip(inst, owner)
	owner.AnimState:Hide("ARM_carry")
	owner.AnimState:Show("ARM_normal")
end

local function fn(Sim)
	local inst = CreateEntity()
	inst.entity:AddTransform()
	inst.entity:AddAnimState()
    
	inst:AddComponent("equippable")
	inst.components.equippable:SetOnEquip(onequip)
    inst.components.equippable:SetOnUnequip(onunequip)
	
    --inst.AnimState:SetBank("manrabbit_tail")
	inst.AnimState:SetBank("ancient_altar_mover")
    inst.AnimState:SetBuild("ancient_altar_mover")
    inst.AnimState:PlayAnimation("idle",true)
    MakeInventoryPhysics(inst)
    
    --inst:AddComponent("stackable")
	--inst.components.stackable.maxsize = TUNING.STACK_SIZE_SMALLITEM

    inst:AddComponent("inspectable")
    
	MakeSmallBurnable(inst)
    MakeSmallPropagator(inst)
    
	inst.stored = false
	
	inst:AddComponent("spellcaster")
    inst.components.spellcaster:SetSpellFn(function(inst, target)
		if inst.stored == true then return end
		SpawnPrefab("collapse_small").Transform:SetPosition(target.Transform:GetWorldPosition())
		target:Remove()
		inst.stored = true
	end)
    inst.components.spellcaster.canuseontargets = true
    inst.components.spellcaster:SetSpellTestFn(function(inst, caster, target)
		if inst.stored == true then return false end
		return target and target.prefab == "ancient_altar"
	end)
	
	inst:ListenForEvent("ondropped",  function(inst)
		if inst.stored == false then return end
		
		local pt = Point(inst.Transform:GetWorldPosition())
		SpawnPrefab("ancient_altar").Transform:SetPosition(pt.x, 0, pt.z)
		SpawnPrefab("collapse_small").Transform:SetPosition(pt.x, 0, pt.z)
		inst:Remove()
	end)
	
	--inst:AddComponent("tradable")    
	--inst.components.tradable.goldvalue = TUNING.GOLD_VALUES.MEAT*2
	
    inst:AddComponent("inventoryitem")
    inst.components.inventoryitem.imagename = "ancient_altar_mover"
    inst.components.inventoryitem.atlasname = "images/ancient_altar_mover.xml"
    inst.components.inventoryitem:GetImage()
    inst.components.inventoryitem:GetAtlas()
    
	
	inst.OnSave = OnSave
	inst.OnLoad = OnLoad

	
	
    --inst:AddComponent("edible")
    --inst.components.edible.foodtype = "HORRIBLE"
    

    return inst
end

return 	Prefab( "common/inventory/ancient_altar_mover", fn, assets)

